<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Kuitansi {{ $payment->receipt_no }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <style>
        :root {
            --primary:#0f766e;
            --bg:#f8fafc;
            --card:#ffffff;
            --text:#0f172a;
            --muted:#64748b;
            --border:#e5e7eb;
            --success:#16a34a;
            --warning:#f59e0b;

          #  --frameOuter:#0f172a; /* garis tebal luar */
          #  --frameInner:#94a3b8; /* garis tipis dalam */
        }

        * { box-sizing: border-box; }
        body {
            margin:0;
            font-family: system-ui, -apple-system, Segoe UI, Roboto, Ubuntu, Cantarell;
            background: var(--bg);
            color: var(--text);
        }

        .container {
            max-width: 880px;
            margin: 32px auto;
            padding: 0 16px;
        }

        .card {
            position: relative;
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 16px;
            box-shadow: 0 10px 25px rgba(0,0,0,.05);
            overflow: hidden;
        }

        /* === FRAME: 2 kotak garis (luar tebal, dalam tipis) === */
        .frame{
            position:absolute;
            inset:14px;
            border:4px solid var(--frameOuter);
            border-radius:12px;
            pointer-events:none;
            z-index: 2;
        }
        .frame::after{
            content:"";
            position:absolute;
            inset:8px;
            border:1.5px solid var(--frameInner);
            border-radius:10px;
            pointer-events:none;
        }
        @media(max-width:720px){
            .frame{ inset:10px; border-width:3px; }
            .frame::after{ inset:7px; }
        }
        @media print{
            .frame{ border-color:#000; }
            .frame::after{ border-color:#000; opacity:.65; }
        }

        /* === WATERMARK: paling depan (z-index tertinggi) === */
        .watermark {
            position:absolute;
            inset:0;
            display:flex;
            align-items:center;
            justify-content:center;
            pointer-events:none;
            z-index: 50; /* Paling depan */
        }
        .watermark .stamp{
            display:flex;
            flex-direction:column;
            align-items:center;
            justify-content:center;
            gap:10px;
            transform: rotate(-18deg);
            user-select:none;
            white-space:nowrap;
        }

        .watermark .stamp .big{
            font-size:92px;
            font-weight:1000;
            letter-spacing:6px;
            color: rgba(22,163,74,.18);
            text-transform: uppercase;
            line-height:1;
        }
        .watermark .stamp .sub{
            font-size:18px;
            font-weight:900;
            letter-spacing:3px;
            color: rgba(22,163,74,.22);
            text-transform: uppercase;
        }

        .watermark .stamp .ring{
            position:absolute;
            width: 520px;
            height: 220px;
            border: 6px solid rgba(22,163,74,.20);
            border-radius: 999px;
            box-shadow: 0 0 0 2px rgba(22,163,74,.10) inset;
        }

        @media(max-width:720px){
            .watermark .stamp .big{ font-size:62px; letter-spacing:4px; }
            .watermark .stamp .sub{ font-size:14px; letter-spacing:2px; }
            .watermark .stamp .ring{ width: 360px; height: 170px; border-width:5px; }
        }

        @media print{
            .watermark .stamp .big{ color: rgba(0,0,0,.12); }
            .watermark .stamp .sub{ color: rgba(0,0,0,.12); }
            .watermark .stamp .ring{ border-color: rgba(0,0,0,.12); box-shadow:none; }
        }

        /* content layer */
        .card > .layer {
            position: relative;
            z-index: 10; /* di atas frame, tapi di bawah watermark */
        }

        .header {
            padding: 24px;
            display:flex;
            justify-content:space-between;
            align-items:center;
            gap:16px;
            border-bottom:1px solid var(--border);
        }

        .brand h1 {
            margin:0;
            font-size:20px;
            letter-spacing:.3px;
        }

        .brand small {
            color:var(--muted);
        }

        .status {
            padding:6px 12px;
            border-radius:999px;
            font-size:12px;
            font-weight:700;
            text-transform:uppercase;
            border: 1px solid var(--border);
            background: #fff;
        }

        .status.paid { background:#dcfce7; color:var(--success); border-color: rgba(22,163,74,.25); }
        .status.partial { background:#fef3c7; color:var(--warning); border-color: rgba(245,158,11,.35); }

        .content {
            padding: 24px;
            display:grid;
            grid-template-columns: 1fr 220px;
            gap:24px;
        }

        @media(max-width:720px){
            .header{padding:18px; align-items:flex-start;}
            .brand h1{font-size:18px}
            .container{margin:18px auto}
            .content{grid-template-columns:1fr; padding:18px}
        }

        .info table {
            width:100%;
            border-collapse:collapse;
            font-size:14px;
        }

        .info td {
            padding:6px 0;
            vertical-align:top;
        }

        .info td:first-child {
            color:var(--muted);
            width:140px;
        }
        @media(max-width:720px){
            .info td:first-child { width:120px; }
        }

        .qr {
            text-align:center;
            border:1px dashed var(--border);
            border-radius:12px;
            padding:16px;
            background: #fff;
        }

        .qr small {
            display:block;
            margin-top:8px;
            color:var(--muted);
            font-size:12px;
        }

        .items {
            padding: 0 24px 24px;
        }
        @media(max-width:720px){
            .items{ padding: 0 18px 18px; }
        }

        table.items-table {
            width:100%;
            border-collapse:collapse;
            font-size:14px;
        }

        .items-table th,
        .items-table td {
            padding:10px;
            border-bottom:1px solid var(--border);
            text-align:left;
        }

        .items-table th {
            background:#f1f5f9;
            font-weight:700;
            font-size:13px;
        }

        .items-table td.amount,
        .items-table th.amount {
            text-align:right;
        }

        .summary {
            margin-top:16px;
            display:flex;
            justify-content:flex-end;
        }

        .summary table {
            min-width:320px;
            font-size:14px;
        }

        .summary td {
            padding:6px 0;
        }

        .summary tr.total td {
            font-weight:900;
            border-top:1px solid var(--border);
            padding-top:10px;
        }

        .footer {
            padding:20px 24px;
            border-top:1px solid var(--border);
            background:#f8fafc;
            display:flex;
            justify-content:space-between;
            align-items:center;
            gap:12px;
            flex-wrap:wrap;
        }

        .footer-note {
            color:var(--muted);
            font-size:13px;
        }

        .actions {
            display:flex;
            gap:10px;
        }

        .btn {
            padding:10px 14px;
            border-radius:10px;
            border:1px solid var(--border);
            background:white;
            cursor:pointer;
            font-size:14px;
            text-decoration:none;
            color:inherit;
            display:inline-flex;
            align-items:center;
            justify-content:center;
            gap:8px;
        }

        .btn.primary {
            background:var(--primary);
            color:white;
            border-color:var(--primary);
        }

        .btn:hover { opacity:.92; }

        @media(max-width:720px){
            .footer{ padding:16px 18px; }
            .actions{ width:100%; }
            .btn{ flex:1; text-align:center; }
        }

        @media print {
            body { background:white; }
            .actions { display:none; }
            .container { margin:0; }
            .card { box-shadow:none; }
        }

        /* === collapsible history === */
        details.history {
            margin-top: 18px;
            border: 1px solid var(--border);
            border-radius: 14px;
            overflow: hidden;
            background: #fff;
        }

        details.history > summary {
            list-style: none;
            cursor: pointer;
            padding: 14px 14px;
            display:flex;
            align-items:center;
            justify-content:space-between;
            gap:12px;
            background: linear-gradient(0deg, #fff, #f8fafc);
            user-select:none;
        }

        details.history > summary::-webkit-details-marker { display:none; }

        .history-title {
            display:flex;
            align-items:center;
            gap:10px;
            font-weight:800;
            font-size:14px;
        }

        .badge {
            display:inline-flex;
            align-items:center;
            padding:4px 10px;
            border-radius:999px;
            font-size:12px;
            border:1px solid var(--border);
            color: var(--muted);
            background:#fff;
            font-weight:700;
        }

        .chev {
            width: 10px;
            height: 10px;
            border-right: 2px solid var(--muted);
            border-bottom: 2px solid var(--muted);
            transform: rotate(45deg);
            transition: transform .2s ease;
            flex:0 0 auto;
        }

        details.history[open] .chev {
            transform: rotate(-135deg);
        }

        .history-body {
            padding: 0 14px 14px;
            border-top: 1px solid var(--border);
            animation: fadeIn .18s ease;
        }

        @keyframes fadeIn{
            from{opacity:.4; transform: translateY(-2px);}
            to{opacity:1; transform: translateY(0);}
        }
    </style>
</head>
<body>

@php
    // invoice unik yang terkait kuitansi ini
    $invoiceIds = $payment->allocations
        ->pluck('invoice_id')
        ->filter()
        ->unique()
        ->values();

    $invoices = \App\Models\Invoice::query()
        ->with(['items.unit'])
        ->whereIn('id', $invoiceIds)
        ->get();

    // Total invoice (unik, anti dobel)
    $invoiceTotal = (float) $invoices->sum('total_amount');

    // Dibayar pada kuitansi ini
    $paidThisReceipt = (float) $payment->allocations->sum('amount_applied');

    // Dibayar sampai saat ini (pakai invoice.paid_amount)
    $paidToDate = (float) $invoices->sum('paid_amount');

    // Sisa tagihan
    $remaining = max(0, $invoiceTotal - $paidToDate);

    // Status LUNAS / PARTIAL
    $isPaid = $invoiceTotal > 0 && $remaining <= 0.00001;

    // Riwayat pembayaran KHUSUS invoice yang sama
    $historyPayments = \App\Models\Payment::query()
        ->whereHas('allocations', function ($q) use ($invoiceIds) {
            $q->whereIn('invoice_id', $invoiceIds);
        })
        ->with(['allocations.invoice'])
        ->orderBy('paid_at')
        ->get();

    $historyCount = $historyPayments->count();

    // msg WA admin
    $msg = "Halo Admin,\n\nSaya ingin konfirmasi pembayaran:\n"
         . "No Kuitansi: {$payment->receipt_no}\n"
         . "Penyewa: {$payment->tenant->name}\n"
         . "Nominal (kuitansi ini): Rp ".number_format($payment->total_amount,0,',','.')
         . "\n\nLink:\n".route('receipt.public',$payment->public_token);

    $wa = 'https://wa.me/'.preg_replace('/\D+/','', (string) $settings->wa_phone_admin)
        .'?text='.urlencode($msg);
@endphp

<div class="container">
    <div class="card">

        {{-- FRAME 2 GARIS --}}
        <div class="frame"></div>

        {{-- WATERMARK (PALING DEPAN) --}}
        @if($isPaid)
            <div class="watermark">
                <div class="stamp">
                    <div class="ring" aria-hidden="true"></div>
                    <div class="big">LUNAS</div>
                    <div class="sub">PAID</div>
                </div>
            </div>
        @endif

        <div class="layer">

            {{-- HEADER --}}
            <div class="header">
                <div class="brand">
                    <h1>{{ $settings->receipt_brand_name }}</h1>
                    <small>Kuitansi Pembayaran</small>
                </div>

                <div class="status {{ $isPaid ? 'paid' : 'partial' }}">
                    {{ $isPaid ? 'PAID' : 'PARTIAL' }}
                </div>
            </div>

            {{-- CONTENT --}}
            <div class="content">
                <div class="info">
                    <table>
                        <tr>
                            <td>No. Kuitansi</td>
                            <td><strong>{{ $payment->receipt_no }}</strong></td>
                        </tr>
                        <tr>
                            <td>Penyewa</td>
                            <td>{{ $payment->tenant->name }}</td>
                        </tr>
                        <tr>
                            <td>Tanggal Bayar</td>
                            <td>{{ $payment->paid_at->format('d M Y H:i') }}</td>
                        </tr>
                        <tr>
                            <td>Metode</td>
                            <td>{{ strtoupper($payment->method) }}</td>
                        </tr>
                        @if($payment->reference_no)
                            <tr>
                                <td>Referensi</td>
                                <td>{{ $payment->reference_no }}</td>
                            </tr>
                        @endif
                    </table>
                </div>

                {{-- QR --}}
                <div class="qr">
                    {!! QrCode::size(140)->generate(route('receipt.public', $payment->public_token)) !!}
                    <small>Scan untuk verifikasi</small>
                </div>
            </div>

            {{-- ITEMS --}}
            <div class="items">
                <table class="items-table">
                    <thead>
                    <tr>
                        <th>Ruko</th>
                        <th>Deskripsi</th>
                        <th class="amount">Nominal</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($invoices as $inv)
                        @foreach($inv->items as $item)
                            <tr>
                                <td>{{ $item->unit->code }}</td>
                                <td>{{ $item->description }}</td>
                                <td class="amount">Rp {{ number_format($item->amount,0,',','.') }}</td>
                            </tr>
                        @endforeach
                    @empty
                        <tr>
                            <td colspan="3" style="color:var(--muted); padding:14px;">
                                Belum ada alokasi pembayaran ke invoice.
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>

                <div class="summary">
                    <table>
                        <tr>
                            <td>Total Invoice</td>
                            <td align="right">Rp {{ number_format($invoiceTotal,0,',','.') }}</td>
                        </tr>
                        <tr>
                            <td>Dibayar (kuitansi ini)</td>
                            <td align="right">Rp {{ number_format($paidThisReceipt,0,',','.') }}</td>
                        </tr>
                        <tr>
                            <td>Dibayar sampai saat ini</td>
                            <td align="right">Rp {{ number_format($paidToDate,0,',','.') }}</td>
                        </tr>
                        <tr class="total">
                            <td>Sisa Tagihan</td>
                            <td align="right">Rp {{ number_format($remaining,0,',','.') }}</td>
                        </tr>
                    </table>
                </div>

                {{-- RIWAYAT PEMBAYARAN (COLLAPSIBLE) --}}
                <details class="history" id="history">
                    <summary>
                        <div class="history-title">
                            <span>Riwayat Pembayaran</span>
                            <span class="badge">{{ $historyCount }} transaksi</span>
                        </div>
                        <span class="chev"></span>
                    </summary>

                    <div class="history-body">
                        <table class="items-table" style="margin-top:12px">
                            <thead>
                            <tr>
                                <th>Tanggal</th>
                                <th>No. Kuitansi</th>
                                <th>Metode</th>
                                <th class="amount">Nominal</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($historyPayments as $p)
                                <tr @if($p->id === $payment->id) style="background:#ecfeff" @endif>
                                    <td>{{ $p->paid_at->format('d M Y H:i') }}</td>
                                    <td>
                                        {{ $p->receipt_no }}
                                        @if($p->id === $payment->id)
                                            <span style="font-size:11px;color:#0f766e">(ini)</span>
                                        @endif
                                    </td>
                                    <td>{{ strtoupper($p->method) }}</td>
                                    <td class="amount">Rp {{ number_format($p->total_amount,0,',','.') }}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </details>

            </div>

            {{-- FOOTER --}}
            <div class="footer">
                <div class="footer-note">
                    {{ $settings->receipt_footer_note }}
                </div>

                <div class="actions">
                    <button onclick="window.print()" class="btn">Print</button>
                    <a href="{{ $wa }}" target="_blank" class="btn primary">Hubungi Admin</a>
                </div>
            </div>

        </div>
    </div>
</div>

</body>
</html>
