<x-filament::page>
    <div class="space-y-4">
        {{-- FILTER --}}
        <div class="rounded-xl border bg-white p-4 dark:bg-gray-900">
            {{ $this->form }}
        </div>

        {{-- TABLE --}}
        <div class="rounded-xl border bg-white dark:bg-gray-900 overflow-auto">
            <table class="min-w-[1200px] w-full border-collapse text-sm">
                <thead class="sticky top-0 z-10">
                    <tr class="bg-gray-100 dark:bg-gray-800">
                        <th class="border px-3 py-2 text-left whitespace-nowrap">Rekapitulasi</th>
                        @php
                            $monthNames = [1=>'January',2=>'February',3=>'March',4=>'April',5=>'May',6=>'June',7=>'July',8=>'August',9=>'September',10=>'October',11=>'November',12=>'December'];
                        @endphp
                        @foreach($monthNames as $m => $label)
                            <th class="border px-3 py-2 text-center whitespace-nowrap">{{ $label }}</th>
                        @endforeach
                        <th class="border px-3 py-2 text-center whitespace-nowrap">Jumlah</th>
                    </tr>
                </thead>

                <tbody>
                    @forelse($matrix as $row)
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-800/50">
                            <td class="border px-3 py-2 font-medium whitespace-nowrap">
                                {{ $row['unit_name'] }}
                            </td>

                            @foreach(range(1,12) as $m)
                                @php $v = (float)($row['months'][$m] ?? 0); @endphp
                                <td class="border px-3 py-2 text-right whitespace-nowrap">
                                    {{ $v > 0 ? ('Rp' . number_format($v, 0, ',', '.')) : '-' }}
                                </td>
                            @endforeach

                            <td class="border px-3 py-2 text-right font-semibold whitespace-nowrap">
                                {{ $row['total'] > 0 ? ('Rp' . number_format($row['total'], 0, ',', '.')) : '-' }}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="14" class="border px-3 py-6 text-center text-gray-500">
                                Tidak ada data untuk lokasi & tahun ini.
                            </td>
                        </tr>
                    @endforelse
                </tbody>

                @if(!empty($matrix))
                    <tfoot class="sticky bottom-0 z-10">
                        <tr class="bg-blue-50 dark:bg-blue-950/40">
                            <td class="border px-3 py-2 font-bold">Total</td>

                            @foreach(range(1,12) as $m)
                                @php $tv = (float)($totals['months'][$m] ?? 0); @endphp
                                <td class="border px-3 py-2 text-right font-bold whitespace-nowrap">
                                    {{ $tv > 0 ? ('Rp' . number_format($tv, 0, ',', '.')) : '-' }}
                                </td>
                            @endforeach

                            <td class="border px-3 py-2 text-right font-bold whitespace-nowrap">
                                @php $g = (float)($totals['grand'] ?? 0); @endphp
                                {{ $g > 0 ? ('Rp' . number_format($g, 0, ',', '.')) : '-' }}
                            </td>
                        </tr>
                    </tfoot>
                @endif
            </table>
        </div>
        <div class="mt-8">
    <h3 class="text-lg font-semibold">Rekap Nilai Sewa per Bulan (Breakdown / Accrual)</h3>
    <p class="text-sm text-gray-500">Nilai sewa dialokasikan rata ke bulan-bulan dalam periode invoice (meski dibayar di muka).</p>

    <div class="mt-3 overflow-x-auto rounded-xl border border-gray-200 bg-white">
        <table class="w-full text-sm">
            <thead class="bg-gray-50">
            <tr>
                <th class="px-3 py-2 text-left">Rekapitulasi</th>
                @foreach (range(1,12) as $m)
                    <th class="px-3 py-2 text-right">{{ \Carbon\Carbon::create()->month($m)->translatedFormat('F') }}</th>
                @endforeach
                <th class="px-3 py-2 text-right">Total</th>
            </tr>
            </thead>

            <tbody>
            @foreach ($this->matrixAccrual as $row)
                <tr class="border-t">
                    <td class="px-3 py-2">{{ $row['unit_name'] }}</td>
                    @foreach (range(1,12) as $m)
                        <td class="px-3 py-2 text-right">
                            {{ $row['months'][$m] > 0 ? number_format($row['months'][$m], 0, ',', '.') : '-' }}
                        </td>
                    @endforeach
                    <td class="px-3 py-2 text-right font-semibold">
                        {{ $row['total'] > 0 ? number_format($row['total'], 0, ',', '.') : '-' }}
                    </td>
                </tr>
            @endforeach
            </tbody>

            <tfoot class="border-t bg-gray-50">
            <tr>
                <th class="px-3 py-2 text-left">TOTAL</th>
                @foreach (range(1,12) as $m)
                    <th class="px-3 py-2 text-right">
                        {{ ($this->totalsAccrual['months'][$m] ?? 0) > 0 ? number_format($this->totalsAccrual['months'][$m], 0, ',', '.') : '-' }}
                    </th>
                @endforeach
                <th class="px-3 py-2 text-right">
                    {{ ($this->totalsAccrual['grand'] ?? 0) > 0 ? number_format($this->totalsAccrual['grand'], 0, ',', '.') : '-' }}
                </th>
            </tr>
            </tfoot>
        </table>
    </div>
</div>

    </div>
</x-filament::page>
