<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('app_settings', function (Blueprint $table) {
        $table->id();

        $table->boolean('wa_enabled')->default(true);
        $table->string('wa_phone_admin')->nullable();
        $table->string('wa_sender_label')->nullable();
        $table->text('wa_message_template')->nullable();

        $table->boolean('public_receipt_enabled')->default(true);
        $table->unsignedInteger('public_receipt_expiry_days')->default(365);

        $table->string('receipt_brand_name')->default('Ruko BERKAH UMI');
        $table->text('receipt_footer_note')->nullable();

        $table->timestamps();
      });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('app_settings');
    }
};
