<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('payment_allocations', function (Blueprint $table) {
        $table->id();
        $table->foreignId('payment_id')->constrained('payments')->cascadeOnDelete();
        $table->foreignId('invoice_id')->constrained('invoices')->cascadeOnUpdate()->restrictOnDelete();
        $table->decimal('amount_applied', 14, 2);
        $table->timestamps();

        $table->unique(['payment_id','invoice_id'], 'uniq_payment_invoice');
        $table->index(['invoice_id']);
      });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_allocations');
    }
};
