<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('payments', function (Blueprint $table) {
          $table->id();
          $table->foreignId('tenant_id')->constrained('tenants')->cascadeOnUpdate()->restrictOnDelete();

          $table->timestamp('paid_at');
          $table->enum('method', ['cash','transfer','qris','other'])->default('cash');
          $table->string('reference_no')->nullable();

          $table->decimal('total_amount', 14, 2);

          $table->string('receipt_no')->unique();        // RCPT-YYYY-000001
          $table->string('public_token', 64)->unique();  // random
          $table->text('notes')->nullable();

          $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();

          $table->timestamps();

          $table->index(['tenant_id', 'paid_at']);
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
