<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('invoice_items', function (Blueprint $table) {
          $table->id();
          $table->foreignId('invoice_id')->constrained('invoices')->cascadeOnDelete();
          $table->foreignId('lease_id')->constrained('leases')->cascadeOnUpdate()->restrictOnDelete();
          $table->foreignId('unit_id')->constrained('units')->cascadeOnUpdate()->restrictOnDelete();
          $table->string('description');
          $table->decimal('amount', 14, 2);
          $table->timestamps();

          $table->index(['invoice_id']);
          $table->index(['unit_id']);
      });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoice_items');
    }
};
