<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('leases', function (Blueprint $table) {
          $table->id();
          $table->foreignId('unit_id')->constrained('units')->cascadeOnUpdate()->restrictOnDelete();
          $table->foreignId('tenant_id')->constrained('tenants')->cascadeOnUpdate()->restrictOnDelete();

          $table->enum('billing_cycle', ['monthly','yearly']);
          $table->date('start_date');
          $table->date('end_date')->nullable();

          $table->decimal('price_amount', 14, 2);
          $table->unsignedTinyInteger('due_day')->nullable();
          $table->unsignedTinyInteger('yearly_anchor_month')->default(8); // default Agustus
          $table->boolean('prorate_enabled')->default(true);

          $table->enum('status', ['draft','active','ended'])->default('draft');
          $table->text('notes')->nullable();
          $table->timestamps();

          $table->index(['unit_id', 'status']);
          $table->index(['tenant_id', 'status']);
          $table->index(['billing_cycle', 'status']);
      });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('leases');
    }
};
