<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('tenants', function (Blueprint $table) {
          $table->id();
          $table->string('name');
          $table->string('phone')->nullable();
          $table->string('email')->nullable();
          $table->text('address')->nullable();
          $table->text('notes')->nullable();
          $table->boolean('is_active')->default(true);
          $table->timestamps();

          $table->index(['is_active']);
          $table->index(['name']);
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tenants');
    }
};
