<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('units', function (Blueprint $table) {
        $table->id();
        $table->foreignId('location_id')->constrained()->cascadeOnUpdate()->restrictOnDelete();
        $table->string('code')->unique();
        $table->string('name');
        $table->decimal('default_monthly_price', 14, 2)->default(0);
        $table->unsignedTinyInteger('default_due_day')->nullable(); // 1-31
        $table->text('notes')->nullable();
        $table->boolean('is_active')->default(true);
        $table->timestamps();

        $table->index(['location_id', 'is_active']);
      });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('units');
    }
};
