<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Unit extends Model {
  protected $fillable = ['location_id','code','name','default_monthly_price','default_due_day','notes','is_active'];
  public function location(){ return $this->belongsTo(Location::class); }
  public function leases(){ return $this->hasMany(Lease::class); }
  public function activeLease(){
    return $this->hasOne(Lease::class)->where('status','active');
  }
}
