<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Lease extends Model {
  protected $fillable = [
    'unit_id','tenant_id','billing_cycle','start_date','end_date',
    'price_amount','due_day','yearly_anchor_month','prorate_enabled','status','notes'
  ];
  protected $casts = [
    'start_date'=>'date','end_date'=>'date','prorate_enabled'=>'bool'
  ];
  public function unit(){ return $this->belongsTo(Unit::class); }
  public function tenant(){ return $this->belongsTo(Tenant::class); }
  public function invoiceItems(){ return $this->hasMany(InvoiceItem::class); }
}
