<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AppSetting extends Model {
  protected $fillable = [
    'wa_enabled','wa_phone_admin','wa_sender_label','wa_message_template',
    'public_receipt_enabled','public_receipt_expiry_days',
    'receipt_brand_name','receipt_footer_note'
  ];

  public static function singleton(): self {
    return static::query()->firstOrCreate(['id'=>1], ['receipt_brand_name'=>'Ruko BERKAH UMI']);
  }

  public static function get(string $key, $default=null){
    $s = static::singleton();
    return data_get($s, $key, $default);
  }
}
