<?php
namespace App\Http\Controllers;

use App\Models\AppSetting;
use App\Models\Payment;
use Illuminate\Http\Request;

class PublicReceiptController extends Controller
{
    public function show(Request $request, string $token)
    {
        $settings = AppSetting::singleton();

        abort_unless($settings->public_receipt_enabled, 404);

    /*    $payment = Payment::query()
            ->with(['tenant','allocations.invoice.items.unit','allocations.invoice'])
            ->where('public_token', $token)
            ->firstOrFail();*/

            $payment = Payment::query()
              ->with([
                  'tenant',
                  'allocations.invoice.items.unit',
                  'allocations.invoice',
                  'tenant.payments' => function ($q) {
                      $q->orderBy('paid_at');
                  }
              ])
              ->where('public_token', $token)
              ->firstOrFail();


        // expiry
        $expiryDays = (int) $settings->public_receipt_expiry_days;
        if ($expiryDays > 0) {
            abort_if($payment->created_at->lt(now()->subDays($expiryDays)), 410, 'Link kuitansi sudah kadaluarsa.');
        }

        return view('public.receipt', compact('payment','settings'));
    }
}
