<?php

namespace App\Http\Controllers;

use App\Models\Payment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class PaymentProofController extends Controller
{
    public function show(Request $request, Payment $payment)
    {
        // Kalau mau dibatasi (admin/petugas), cek di sini:
        // abort_unless(auth()->check(), 403);

        $path = $payment->proof_image;

        if (blank($path) || ! Storage::disk('public')->exists($path)) {
            abort(404);
        }

        // Kirim file sebagai response (inline)
        return Storage::disk('public')->response($path);
    }
}
