<?php

namespace App\Filament\Widgets\Ruko;

use App\Models\Unit;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget;
use Illuminate\Database\Eloquent\Builder;

class VacantUnitsTable extends TableWidget
{
    protected static ?string $heading = 'Unit Kosong';
    protected int|string|array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        return $table
            ->query($this->getQuery())
            ->defaultPaginationPageOption(10)
            ->columns([
                Tables\Columns\TextColumn::make('location.name')->label('Lokasi')->searchable(),
                Tables\Columns\TextColumn::make('name')->label('Unit')->searchable(),
                Tables\Columns\TextColumn::make('code')->label('Kode')->toggleable(),
                Tables\Columns\TextColumn::make('price_monthly')->label('Harga/bln')->money('IDR', true)->toggleable(),
            ]);
    }

    protected function getQuery(): Builder
    {
        return Unit::query()
            ->where('is_active', true)
            ->whereDoesntHave('leases', function ($q) {
                $q->whereIn('status', ['active'])
                  ->whereDate('start_date', '<=', now()->toDateString())
                  ->where(function ($qq) {
                      $qq->whereNull('end_date')->orWhereDate('end_date', '>=', now()->toDateString());
                  });
            })
            ->with('location')
            ->orderBy('location_id')
            ->orderBy('name');
    }
}
