<?php

namespace App\Filament\Widgets\Ruko;

use App\Models\Invoice;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget;
use Illuminate\Database\Eloquent\Builder;

class UpcomingDueInvoicesTable extends TableWidget
{
    protected static ?string $heading = 'Invoice Jatuh Tempo 14 Hari ke Depan';
    protected int|string|array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        return $table
            ->query($this->getQuery())
            ->defaultPaginationPageOption(10)
            ->columns([
                Tables\Columns\TextColumn::make('invoice_no')->label('No')->searchable(),
                Tables\Columns\TextColumn::make('tenant.name')->label('Tenant')->searchable(),
                Tables\Columns\TextColumn::make('due_date')->label('Jatuh Tempo')->date(),
                Tables\Columns\TextColumn::make('total_amount')->label('Total')->money('IDR', true),
                Tables\Columns\TextColumn::make('paid_amount')->label('Terbayar')->money('IDR', true),
                Tables\Columns\TextColumn::make('status')->label('Status')->badge(),
            ])
            ->actions([
                Tables\Actions\Action::make('detail')
                    ->label('Lihat')
                    ->url(fn ($record) => route('filament.admin.resources.invoices.view', $record)), // sesuaikan route resource
            ]);
    }

    protected function getQuery(): Builder
    {
        return Invoice::query()
            ->whereBetween('due_date', [now()->toDateString(), now()->addDays(14)->toDateString()])
            ->whereIn('status', ['sent','partial'])
            ->latest('due_date');
    }
}
