<?php

namespace App\Filament\Widgets\Ruko;

use App\Models\Payment;
use Filament\Widgets\ChartWidget;

class RevenueTrendChart extends ChartWidget
{
    protected static ?string $heading = 'Pendapatan 12 Bulan Terakhir';

    protected function getData(): array
    {
        $labels = [];
        $data = [];

        for ($i = 11; $i >= 0; $i--) {
            $start = now()->subMonths($i)->startOfMonth();
            $end   = now()->subMonths($i)->endOfMonth();

            $labels[] = $start->format('M Y');
            $data[] = (float) Payment::query()
                ->whereBetween('paid_at', [$start, $end])
                ->sum('total_amount');
        }

        return [
            'datasets' => [
                [
                    'label' => 'Pendapatan',
                    'data' => $data,
                ],
            ],
            'labels' => $labels,
        ];
    }

    protected function getType(): string
    {
        return 'line';
    }
}
