<?php

namespace App\Filament\Widgets\Ruko;

use App\Models\Payment;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget;
use Illuminate\Database\Eloquent\Builder;

class RecentPaymentsTable extends TableWidget
{
    protected static ?string $heading = 'Pembayaran Terbaru';
    protected int|string|array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        return $table
            ->query($this->getQuery())
            ->defaultPaginationPageOption(10)
            ->columns([
                Tables\Columns\TextColumn::make('receipt_no')->label('Kuitansi')->searchable(),
                Tables\Columns\TextColumn::make('tenant.name')->label('Tenant')->searchable(),
                Tables\Columns\TextColumn::make('paid_at')->label('Tanggal')->dateTime('d M Y H:i'),
                Tables\Columns\TextColumn::make('method')->label('Metode')->badge(),
                Tables\Columns\TextColumn::make('total_amount')->label('Nominal')->money('IDR', true),
            ]);
    }

    protected function getQuery(): Builder
    {
        return Payment::query()->latest('paid_at');
    }
}
