<?php

namespace App\Filament\Widgets\Ruko;

use App\Models\Invoice;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget;
use Illuminate\Database\Eloquent\Builder;

class OverdueInvoicesTable extends TableWidget
{
    protected static ?string $heading = 'Invoice Overdue (Top 20)';
    protected int|string|array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        return $table
            ->query($this->getQuery())
            ->defaultPaginationPageOption(10)
            ->columns([
                Tables\Columns\TextColumn::make('invoice_no')->label('No')->searchable(),
                Tables\Columns\TextColumn::make('tenant.name')->label('Tenant')->searchable(),
                Tables\Columns\TextColumn::make('due_date')->label('Jatuh Tempo')->date(),
                Tables\Columns\TextColumn::make('outstanding')
                    ->label('Sisa')
                    ->getStateUsing(fn ($record) => max(0, (float)$record->total_amount - (float)$record->paid_amount))
                    ->money('IDR', true),
                Tables\Columns\TextColumn::make('status')->label('Status')->badge(),
            ])
            ->defaultSort('due_date', 'asc');
    }

    protected function getQuery(): Builder
    {
        return Invoice::query()
            ->whereDate('due_date', '<', now()->toDateString())
            ->whereIn('status', ['sent','partial','overdue'])
            ->latest('due_date');
    }
}
