<?php

namespace App\Filament\Widgets\Ruko;

use App\Models\Invoice;
use Filament\Widgets\ChartWidget;

class InvoiceStatusChart extends ChartWidget
{
    protected static ?string $heading = 'Status Invoice (30 Hari Terakhir)';

    protected function getData(): array
    {
        $start = now()->subDays(30)->startOfDay();

        $counts = Invoice::query()
            ->whereDate('created_at', '>=', $start)
            ->selectRaw('status, COUNT(*) as total')
            ->groupBy('status')
            ->pluck('total', 'status')
            ->toArray();

        $labels = array_keys($counts);
        $data   = array_values($counts);

        return [
            'datasets' => [
                [
                    'label' => 'Jumlah Invoice',
                    'data' => $data,
                ],
            ],
            'labels' => $labels,
        ];
    }

    protected function getType(): string
    {
        return 'doughnut';
    }
}
