<?php

namespace App\Filament\Resources;

use App\Filament\Resources\UnitResource\Pages;
use App\Models\Unit;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class UnitResource extends Resource
{
    protected static ?string $model = Unit::class;

    protected static ?string $navigationGroup = 'Master Data';
    protected static ?string $navigationIcon = 'heroicon-o-building-storefront';
    protected static ?string $navigationLabel = 'Ruko';
    protected static ?int $navigationSort = 82;

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('Data Ruko')
                ->columns(2)
                ->schema([
                    Forms\Components\Select::make('location_id')
                        ->label('Lokasi')
                        ->relationship('location', 'name')
                        ->searchable()
                        ->preload()
                        ->required(),

                    Forms\Components\TextInput::make('code')
                        ->label('Kode Ruko')
                        ->required()
                        ->maxLength(50)
                        ->unique(ignoreRecord: true),

                    Forms\Components\TextInput::make('name')
                        ->label('Nama Ruko')
                        ->required()
                        ->maxLength(255),

                    Forms\Components\TextInput::make('default_monthly_price')
                        ->label('Harga Bulanan Default')
                        ->numeric()
                        ->prefix('Rp')
                        ->required(),

                    Forms\Components\TextInput::make('default_due_day')
                        ->label('Tanggal Jatuh Tempo Default (1-31)')
                        ->numeric()
                        ->minValue(1)
                        ->maxValue(31),

                    Forms\Components\Toggle::make('is_active')->label('Aktif')->default(true),

                    Forms\Components\Textarea::make('notes')->label('Catatan')->columnSpanFull(),
                ]),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('location.name')->label('Lokasi')->sortable()->searchable(),
                Tables\Columns\TextColumn::make('code')->label('Kode')->sortable()->searchable(),
                Tables\Columns\TextColumn::make('name')->label('Nama')->sortable()->searchable(),
                Tables\Columns\TextColumn::make('default_monthly_price')->label('Harga')->money('IDR', true)->sortable(),
                Tables\Columns\TextColumn::make('default_due_day')->label('Due')->sortable(),
                Tables\Columns\IconColumn::make('is_active')->label('Aktif')->boolean()->sortable(),
            ])
            ->defaultSort('created_at', 'desc')
            ->filters([
                Tables\Filters\TernaryFilter::make('is_active')->label('Aktif'),
                Tables\Filters\SelectFilter::make('location_id')->label('Lokasi')->relationship('location', 'name')->searchable()->preload(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\DeleteBulkAction::make(),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListUnits::route('/'),
            'create' => Pages\CreateUnit::route('/create'),
            'edit' => Pages\EditUnit::route('/{record}/edit'),
        ];
    }
}
