<?php

namespace App\Filament\Resources\PaymentResource\Pages;

use App\Domain\Rent\Services\PaymentAllocatorService;
use App\Filament\Resources\PaymentResource;
use Filament\Resources\Pages\CreateRecord;

class CreatePayment extends CreateRecord
{
    protected static string $resource = PaymentResource::class;

    protected function handleRecordCreation(array $data): \Illuminate\Database\Eloquent\Model
    {
        return app(PaymentAllocatorService::class)->createPaymentAndAutoAllocate([
            'tenant_id'    => (int) $data['tenant_id'],
            'paid_at'      => $data['paid_at'],
            'method'       => $data['method'],
            'reference_no' => $data['reference_no'] ?? null,
            'total_amount' => (float) $data['total_amount'],
            'notes'        => $data['notes'] ?? null,
            'created_by'   => auth()->id(),
        ]);
    }
}
