<?php

namespace App\Filament\Resources\InvoiceResource\Pages;

use App\Domain\Rent\Services\InvoiceGeneratorService;
use App\Filament\Resources\InvoiceResource;
use App\Models\Tenant;
use Filament\Actions;
use Filament\Forms;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Support\Carbon;
use App\Domain\Rent\Support\HandlesInvoicePayment;

class ListInvoices extends ListRecords
{
    use HandlesInvoicePayment;
    protected static string $resource = InvoiceResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('generateManual')
                ->label('Generate Invoice Manual')
                ->icon('heroicon-o-bolt')
                ->form([
                    Forms\Components\Select::make('tenant_id')
                        ->label('Penyewa')
                        ->options(Tenant::query()->orderBy('name')->pluck('name', 'id'))
                        ->searchable()
                        ->required(),

                    Forms\Components\DatePicker::make('run_date')
                        ->label('Tanggal Generate (run date)')
                        ->default(now())
                        ->required(),
                ])
                ->action(function (array $data) {
                    $res = app(InvoiceGeneratorService::class)
                        ->generateForTenantForDate(
                            (int) $data['tenant_id'],
                            Carbon::parse($data['run_date'])
                        );

                    Notification::make()
                        ->title('Selesai generate invoice')
                        ->body("Created: {$res['created']}, Skipped: {$res['skipped']}")
                        ->success()
                        ->send();
                }),
        ];
    }
}
