<?php

namespace App\Filament\Resources;

use App\Filament\Resources\AppSettingResource\Pages;
use App\Models\AppSetting;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;

class AppSettingResource extends Resource
{
    protected static ?string $model = AppSetting::class;

    protected static ?string $navigationGroup = 'Pengaturan';
    protected static ?string $navigationIcon = 'heroicon-o-cog-6-tooth';
    protected static ?string $navigationLabel = 'Pengaturan Aplikasi';
    protected static ?int $navigationSort = 90;

    public static function canCreate(): bool { return false; }
    public static function canDelete(\Illuminate\Database\Eloquent\Model $record): bool { return false; }

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('WhatsApp')
                ->columns(2)
                ->schema([
                    Forms\Components\Toggle::make('wa_enabled')
                        ->label('Aktifkan WhatsApp')
                        ->default(true),

                    Forms\Components\TextInput::make('wa_phone_admin')
                        ->label('Nomor WhatsApp Admin (62xxxx)')
                        ->helperText('Contoh: 62812xxxxxxx (tanpa +)')
                        ->tel()
                        ->maxLength(32),

                    Forms\Components\TextInput::make('wa_sender_label')
                        ->label('Label Pengirim (opsional)')
                        ->maxLength(100),

                    Forms\Components\Textarea::make('wa_message_template')
                        ->label('Template Pesan WhatsApp')
                        ->rows(6)
                        ->helperText("Placeholder: {tenant_name}, {receipt_no}, {amount}, {public_url}")
                        ->columnSpanFull(),
                ]),

            Forms\Components\Section::make('Kuitansi Publik')
                ->columns(2)
                ->schema([
                    Forms\Components\Toggle::make('public_receipt_enabled')
                        ->label('Aktifkan Kuitansi Publik')
                        ->default(true),

                    Forms\Components\TextInput::make('public_receipt_expiry_days')
                        ->label('Masa Aktif Link (hari)')
                        ->numeric()
                        ->minValue(0)
                        ->default(365),

                    Forms\Components\TextInput::make('receipt_brand_name')
                        ->label('Nama Brand di Kuitansi')
                        ->required()
                        ->maxLength(150)
                        ->default('Ruko BERKAH UMI'),

                    Forms\Components\Textarea::make('receipt_footer_note')
                        ->label('Catatan Footer Kuitansi')
                        ->rows(3)
                        ->columnSpanFull(),
                ]),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('receipt_brand_name')->label('Brand')->searchable(),
                Tables\Columns\IconColumn::make('wa_enabled')->label('WA')->boolean(),
                Tables\Columns\IconColumn::make('public_receipt_enabled')->label('Public')->boolean(),
                Tables\Columns\TextColumn::make('updated_at')->label('Updated')->dateTime()->sortable(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([]); // kosongkan bulk actions
    }

    public static function getEloquentQuery(): Builder
    {
        // Pastikan selalu ada satu record id=1
        AppSetting::singleton();
        return parent::getEloquentQuery()->where('id', 1);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ManageAppSettings::route('/'),
        ];
    }
}
