<?php

namespace App\Filament\Pages;

use Filament\Pages\Dashboard as BaseDashboard;

class RukoDashboard extends BaseDashboard
{
    protected static ?string $navigationIcon = 'heroicon-o-home-modern';
    protected static ?string $navigationLabel = 'Dashboard Ruko';
    protected static ?string $title = 'Dashboard Ruko Berkah Umi';
    protected static ?string $navigationGroup = 'Dashboard';
    //protected static ?int $navigationSort = 1;

    public function getWidgets(): array
    {
        return [
            \App\Filament\Widgets\Ruko\RukoStatsOverview::class,
            \App\Filament\Widgets\Ruko\RevenueTrendChart::class,
            \App\Filament\Widgets\Ruko\OccupancyByLocationChart::class,
            \App\Filament\Widgets\Ruko\InvoiceStatusChart::class,

            \App\Filament\Widgets\Ruko\UpcomingDueInvoicesTable::class,
            \App\Filament\Widgets\Ruko\OverdueInvoicesTable::class,
            \App\Filament\Widgets\Ruko\RecentPaymentsTable::class,
            \App\Filament\Widgets\Ruko\VacantUnitsTable::class,
        ];
    }
}
