<?php

namespace App\Domain\Rent\Support;

use Carbon\Carbon;

class PeriodCalculator
{
    /**
     * Rolling monthly: periode 1 bulan sejak start_date, yang mencakup runDate.
     * Contoh: start 2026-02-13 => 2026-02-13 s/d 2026-03-12
     */
    public static function monthlyRolling(Carbon $runDate, Carbon $leaseStart): array
    {
        $leaseStart = $leaseStart->copy()->startOfDay();

        if ($runDate->lt($leaseStart)) {
            $ps = $leaseStart->copy();
            $pe = $ps->copy()->addMonthNoOverflow()->subDay()->endOfDay();
            return [$ps, $pe];
        }

        $months = $leaseStart->diffInMonths($runDate);
        $ps = $leaseStart->copy()->addMonthsNoOverflow($months)->startOfDay();

        // jaga-jaga kalau overflow tanggal membuat ps > runDate
        if ($runDate->lt($ps)) {
            $ps = $ps->subMonthNoOverflow()->startOfDay();
        }

        $pe = $ps->copy()->addMonthNoOverflow()->subDay()->endOfDay();
        return [$ps, $pe];
    }

    /**
     * Rolling yearly: periode 12 bulan sejak start_date, yang mencakup runDate.
     * Contoh: start 2026-02-13 => 2026-02-13 s/d 2027-02-12
     */
    public static function yearlyRolling(Carbon $runDate, Carbon $leaseStart): array
    {
        $leaseStart = $leaseStart->copy()->startOfDay();

        if ($runDate->lt($leaseStart)) {
            $ps = $leaseStart->copy();
            $pe = $ps->copy()->addYearNoOverflow()->subDay()->endOfDay();
            return [$ps, $pe];
        }

        $months = $leaseStart->diffInMonths($runDate);
        $yearIndex = intdiv($months, 12);

        $ps = $leaseStart->copy()->addYearsNoOverflow($yearIndex)->startOfDay();

        // jaga-jaga overflow
        if ($runDate->lt($ps)) {
            $ps = $ps->subYearNoOverflow()->startOfDay();
        }

        $pe = $ps->copy()->addYearNoOverflow()->subDay()->endOfDay();
        return [$ps, $pe];
    }
}
