<?php

namespace App\Console\Commands;

use App\Domain\Rent\Services\InvoiceGeneratorService;
use Carbon\Carbon;
use Illuminate\Console\Command;

class GenerateRentInvoices extends Command
{
    protected $signature = 'rent:generate-invoices {--date=}';
    protected $description = 'Generate invoices otomatis untuk sewa ruko (group by tenant + period).';

    public function handle(InvoiceGeneratorService $svc): int
    {
        $dateOpt = $this->option('date');
        $runDate = $dateOpt ? Carbon::parse($dateOpt) : now();

        $res = $svc->generateForDate($runDate);

        $this->info("Created: {$res['created']}, Skipped: {$res['skipped']}");

        return self::SUCCESS;
    }
}
